using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityStandardAssets.CrossPlatformInput;

class PlayerMovement : MonoBehaviour {

    public delegate void onPlayerTriggerEvent(GameObject obj);
    public static event onPlayerTriggerEvent onPlayerTrigger;

    public delegate void onPlayerLandingEvent(GameObject obj);
    public static event   onPlayerLandingEvent onPlayerLanding;

    public float m_Speed    = 2.0f;
    public float m_TurnSpeed    = 200f;
    public float m_Force = 4.0f;
    public bool isLanding {
        get {
            return _isLanding;
        }
    }

    public Animator walkAnimator;
    Rigidbody _rb;
    // Animator _animator;
    
    bool _isGround;
    bool _wasGrounded;
    bool _isLanding;
    Vector3 _movement;
    float _currentV = 0f;
    float _currentH = 0f;
    float _interpolation    = 10f;
    Vector3 _direction  = Vector3.zero;


    void Awake()
    {
        _rb = GetComponent<Rigidbody> ();

        // _animator = GetComponent<Animator> ();
    }

    void FixedUpdate() 
    {
#if MOBILE_INPUT
        float h = CrossPlatformInputManager.GetAxis("HorizontalL") + CrossPlatformInputManager.GetAxis("HorizontalR");
#else
        float h = Input.GetAxis("Horizontal");
#endif // MOBILE_INPUT
        float v = CrossPlatformInputManager.GetAxis("Vertical");
        _currentH   = Mathf.Lerp(_currentH, h, Time.deltaTime * _interpolation);
        _currentV   = Mathf.Lerp(_currentV, v, Time.deltaTime * _interpolation);

        CheckWalking(h);

        Move(h, v);

        ForceMovement();

        _wasGrounded    = _isGround;
    }

    void OnCollisionEnter(Collision collision)
    {
        if (collision.gameObject.tag == "Bottom") {
            ContactPoint[] contactPoints = collision.contacts;
            for(int i = 0; i < contactPoints.Length; i++)
            {
                if (Vector3.Dot(contactPoints[i].normal, Vector3.up) > 0.5f)
                {
                    _isGround = true;

                    if (onPlayerLanding != null) {
                        onPlayerLanding(collision.gameObject);
                    }
                }
            }
        }
    }

     void OnCollisionStay(Collision collision)
    {
        
    }

    void OnCollisionExit(Collision collision)
    {
        if (collision.gameObject.tag == "Bottom") {
            _wasGrounded    = true;
            _isGround       = false;

            if (onPlayerLanding != null) {
                onPlayerLanding(null);
            }
        }
    }

     void OnTriggerEnter(Collider other)
    {
        onPlayerTrigger(other.gameObject);
    }

    void Move(float h, float v)
    {
        Transform camera = Camera.main.transform;

        Vector3 direction = camera.forward * _currentV + camera.right * _currentH;

        float directionLength = direction.magnitude;
        direction.y = 0;
        direction = direction.normalized * directionLength;

        if(direction != Vector3.zero)
        {
            _direction = Vector3.Slerp(_direction, direction, Time.deltaTime * _interpolation);

            transform.rotation = Quaternion.LookRotation(_direction);

            Vector3 position    = transform.position + (_direction * m_Speed * Time.deltaTime);
            position.z          = 0f;

            transform.position = position;

            // _animator.SetFloat("MoveSpeed", direction.magnitude);
        }

        Landing();
    }

    void Landing()
    {
        if (!_wasGrounded && _isGround) {
            // _animator.SetTrigger("Land");
        } 
    }

    void ForceMovement()
    {
        Vector3 position = transform.position;

        position.x += (m_Force * Time.deltaTime);

        transform.position = position;
    }

    void CheckWalking(float movement)
    {
        if (movement != 0) {
            // 버튼을 눌러 이동중인 상태이다.
            walkAnimator.enabled = true;
        } else {
            // 버튼을 누르지 않은 상태이다.
            walkAnimator.enabled = false;
        }
    }
}